require( "quest/m3_pancake/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		if game:GetLastScene() == "m3_apartment" then
			actor:FaceNow(DIR.W);
			actor:JumpToNamedPoint("apartment");
			scene:SetCameraFollowActor(scene.CAMERA);
			scene.CAMERA:JumpToNamedPoint("flo_west");
			actor:WalkTo("flo_west");
			wait_walkto();
			spawn_nav_arrow(door_apartment_spec);
		elseif game:GetLastScene() == "subway" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("subway");
			scene:SetCameraFollowActor(scene.CAMERA);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			wait_walkto();
		else
			actor:JumpToNamedPoint("flo_intersection");
			actor:FaceNow(DIR.W);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			scene:SetCameraFollowActor(actor);
			actor:WalkTo("flo_east");
			game:SetString("map_position", "m3_subway");
			wait_walkto();
			
			scene.CAMERA:JumpToNamedPoint("flo_east");
			scene:SetCameraFollowActor(scene.CAMERA);
		end
		
		actor:Face(DIR.S);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(flo_talk);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function flo_talk(flo)
	flo:SetMode(MODE.CUTSCENE);
	if ( game:Get( "bouquets_delivered" ) ~= 1 ) then
		run_super_conversation(flo, "quip_flo_pancake1_A");
	elseif ( game:Get( "found_bernie" ) ~= 1 ) then
		run_super_conversation(flo, "quip_flo_pancake1_B");
	elseif ( game:Get( "need_safe_combo" ) == 1 ) then
		run_super_conversation(flo, "quip_flo_pancake1_C");
	--elseif ( game:Get( "found_rings_quip" ) == 0 ) then
	--	run_super_conversation(flo, "quip_flo_pancake1_D");
	--	game:Set( "found_rings_quip", 1 );
	else
		run_super_conversation(flo, "quip_flo_general");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m3_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function gotowest(flo)
	flo:SetMode(MODE.CUTSCENE);

	if not quest_complete("give_permit") then
		scene.HAL:StartProc(hal_to_talk);
		local haltalks = game:Get( "hal_talks" );
		if ( haltalks == 0 ) then
			run_super_conversation(flo, "conv_go_home");
			game:Set( "hal_talks", 1 );
			if not quest_added("give_permit") then
				add_quest("give_permit");
				wait_subscene();
			end
		elseif ( game:Get( "got_permit" ) == 1 ) then
			run_super_conversation(flo, "conv_hal_give_permit");
		else
			run_super_conversation(flo, "conv_go_home_B");		
		end
		scene.HAL:StartProc(hal_jackhammer);
	else	
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		scene:SetCameraFollowActor(scene.FLO);
		flo:WalkTo("flo_west");
		wait_walkto();
		flo:Face(DIR.S);
		
		game:SetString("map_position", "m3_apartment");
		spawn_nav_arrow(door_apartment_spec);
		
		flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		scene.CAMERA:JumpToNamedPoint("flo_west");
		scene:SetCameraFollowActor(scene.CAMERA);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_west_spec = 
{
	name = "TO_WEST";
	halo = "to_west";
	cursor = "cursor_arrow_w";
	goto_fn = gotowest;	
}

function gotoeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_APARTMENT:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("camera_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	game:SetString("map_position", "m3_subway");
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("camera_east");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_east_spec = 
{
	name = "TO_EAST";
	halo = "to_east";
	cursor = "cursor_arrow_e";
	goto_fn = gotoeast;
}

function goto_subway(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("subway");
	delay(30);
	
	goto_scene(flo, "subway");
end

to_subway_spec = 
{
	name = "TO_SUBWAY";
	halo = "subway";
	cursor = "cursor_arrow_s";
	goto_fn = goto_subway;
}

function gotoapartment(flo)
	flo:SetMode(MODE.CUTSCENE);
	if not quest_complete("flowers") then
		run_super_conversation(flo, "backup_quip_flower_shop");
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif ( game:Get( "found_bernie" ) ~= 1 ) then
		run_super_conversation(flo, "backup_quip_find_bernie");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		if ( game:Get( "found_apartment_key" ) == 1 ) then
			flo:SetMode(MODE.CUTSCENE);
			flo:WalkTo("apartment");
			delay(30);
			
			goto_scene(flo, "m3_apartment");
		else
			game:SetString("purse_level", "level_four");		
			scene:ChainToSubScene("purse");
			wait_subscene();
			raise_hud();
			
			while not hud_raised() do
				delay(1);
			end
			
			if game:Get("found_apartment_key") == 1 then
				goto_scene( flo, "m3_apartment" );
			else
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		end
	end
end

door_apartment_spec = 
{
	name = "DOOR_APARTMENT";
	halo = "apartment";
	cursor = "cursor_arrow_n";
	goto_fn = gotoapartment;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE then
			if ( game:Get( "found_apartment_key" ) == 1 ) then
				if enter then
					scene.DOOR:PlayAnim("Open");
				else
					scene.DOOR:PlayAnim("Close");
				end
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m3_pancake/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("10");
	end;
}

function use_recycle_machine(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("recyclemachine");
	wait_walkto();
	
	flo:FaceActor(actor);
	delay(30);
	
	scene:ChainToSubScene("recyclemachine");
	wait_subscene();
	
	flo:WalkTo("camera_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

recyclemachine_spec = 
{
	name = "RECYCLE_MACHINE";
	halo = "recyclemachine";
	gfx = { image = "recyclemachine" };
	
	command = function(actor)
		actor:SetDepthValue(200);
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		flo:StartProc(use_recycle_machine);
	end;
	
	on_use_inv = function(item, flo, actor)
		if item == "recyclable" then
			flo:StartProc(use_recycle_machine);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

function hal_to_talk(hal)
	sfx:KillSFX();
	sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
	hal:LastingEmotion();
	hal:SetEmotion("talk");
	hal:PlayAnim("DoStandE_talk");
end

function hal_from_talk(hal)
	hal:QuickEmotion();
	hal:ClearEmotion();
	hal:PlayAnim("DoStandE");
	sfx:PlaySFX("audio/sfx/jackhammer.ogg", true);
end

function hal_jackhammer(hal)
	while true do
		hal_from_talk(hal);
		delay(300);
		hal_to_talk(hal)
		delay(300);
	end
end

function conv_hal(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.HAL:StartProc(hal_to_talk);
	
	if not quest_complete("flowers") then
		if not quest_complete("give_permit") and BAG_INV:CheckInventory("permit_stamped") == false then
			run_super_conversation(flo, "conv_hal_chat");
			
			if not quest_added("give_permit") then
				add_quest("give_permit");
				wait_subscene();
			end
		else
			run_super_conversation(flo, "conv_hal_found_bernie");
		end
	elseif not quest_complete("find_bernie") then
		run_super_conversation(flo, "conv_hal_wheres_bernie");
	else
		run_super_conversation(flo, "conv_hal_found_bernie");
	end
	
	scene.HAL:StartProc(hal_jackhammer);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_inv_on_hal(flo, item)
	flo:StartProc(function(flo)
		flo:SetMode(MODE.CUTSCENE);
		scene.HAL:StartProc(hal_to_talk);
		if ( item == "permit" ) then	
			run_super_conversation(flo, "conv_hal_permit_bad");
		elseif ( item == "permit_stamped" ) then		
			game:Set( "used_permit", 1 );
			BAG_INV:RemoveInventory( "permit_stamped" );	
			run_super_conversation(flo, "conv_hal_pass");
			complete_quest("give_permit", false);
			wait_subscene();
		else
			run_super_conversation(flo, "conv_hal_reject_item");
		end
		scene.HAL:StartProc(hal_jackhammer);
		flo:SetMode(MODE.FOLLOWCLICKS);
	end);
end

hal_spec = 
{
	name = "HAL";
	halo = "quest/objects/hal";
	gfx = { anim = "anim/hal/pancakerd" };
	
	command = function(actor)
		prepare_actor_text(actor, hal_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = -20, y = -120 } }
		actor:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_FORCEVFLIP 
		};
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
--		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("hal");
		actor:SetWalkSpeed(hal_speed);
		actor:FaceNow(DIR.E);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue(490);
		--actor:PlayAnim( "stand" );
		actor:StartProc(hal_jackhammer);
	end;
	
	on_arrive = function(flo, subway1)
		flo:StartProc(conv_hal);
		
		game:Set("talked_to_hal", 1);
	end;
	
	on_use_inv = function(item, flo, secretary)		
		use_inv_on_hal(flo, item);
	end;
};

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m3_intersection" then
			actor:JumpToNamedPoint("flo_intersection");
		end
	end;
};

function spawn_boats()
	spawn_boat("boat01", false, 222, 3, 0.5);
	spawn_boat("boat02", true, 204, 1, 0.25);
	spawn_boat("boat03", false, 216, 2, 0.35);
end

function spawn_boat(_image, _face_right, _height, _depth, _speed)
	return scene:Spawn
	{
		name = string.upper(_image);
		gfx = { image = _image };
		
		command = function(actor)
			local height = _height-actor:GetImageSize().y;
			actor:SetDepthValue(_depth);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:SetWalkSpeed(_speed);
			local background_width = 2400;
			local left_edge = -actor:GetImageSize().x-100;
			local right_edge = background_width+100;
			
			actor:JumpToPoint { x = math.random(0, background_width), y = height };
			
			while true do
				local sail_right = math.random(1,2) == 2;
				local xpos = right_edge;
				if sail_right then
					xpos = left_edge;
				end
				
				if _face_right ~= sail_right then
					actor:SetScaleX(-1);
				else
					actor:SetScaleX(1);
				end
				
				local walkToX = left_edge;
				
				if sail_right then
					walkToX = right_edge;
				end
				
				actor:WalkToXY{ x = walkToX, y = height };
				wait_walkto(actor);
				actor:JumpToPoint { x = xpos, y = height };
			end
		end;
	}
end

subway_sign_spec = 
{
	name = "SUBWAY_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.29, g = 0.17, b = 0.14 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_subway_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1439,y=206}, {x=1529,y=206}, {x=1436,y=237}, {x=1526,y=238});
		actor:TextToImage(5, 5);
	end;
}

number_sign_spec = 
{
	name = "NUMBER_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(100);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.9, g = 0.9, b = 1 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_number_sign");
		actor:StopWalking();
		actor:SetPolygon({x=256,y=159}, {x=289,y=160}, {x=257,y=178}, {x=289,y=177});
		actor:TextToImage(5, 15);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets3.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		--scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		--fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--game:Set( "used_permit", 1);
			--game:Set( "found_bernie", 1);
			--complete_quest("give_permit", false);
			--complete_quest("flowers", false);
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_west_spec);
		spawn_nav_arrow(to_east_spec);
		spawn_nav_arrow(to_subway_spec);
		
		scene:SetRoomScale(300, 550, 0.5, 0.7);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m3_intersection";
		fade_scene_up(false, no_fade);
		
		--scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if ( game:Get( "used_permit" ) ~= 1 ) then	
			scene:Spawn(hal_spec);
		end
		
		spawn_boats();
		
		spawn_simple_hotspot("end_of_street", 5);
		spawn_simple_hotspot("pancake_dirt", 5);
		spawn_simple_hotspot("pancake_nautical", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },
		
		 {"block01", 450 },
		 {"block02", 450 },
		 {"block03", 450 },
		 {"car01", 450 },
		 {"car02", 450 },
		 {"cone01", 450 },
		 {"cone02", 450 },
		 {"cone03", 450 },
		 {"cone04", 450 },
		 {"cone05", 450 },
		 {"cone06", 450 },
		 {"cone07", 450 },
		 {"cone08", 450 },
		 {"cone09", 450 },
		 {"cone10", 450 },
		 {"cone11", 450 },
		 {"cone12", 450 },
		 {"dirt", 451 },
		 {"sign01", 450 },
		 {"sign02", 450 },
		 {"block04", 495 },

		 { "midground", 10 },
		 
		 { "recycle", 11 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		
		flo_spec, -- the main actor
		recyclemachine_spec,
		
		scene_setup,
		door_spec,
		subway_sign_spec,
		number_sign_spec,
	};
};
